/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.AudioBuffer;
import ddf.minim.AudioEffect;
import ddf.minim.AudioListener;
import ddf.minim.Controller;
import ddf.minim.Effectable;
import ddf.minim.EffectsChain;
import ddf.minim.Recordable;
import ddf.minim.SignalSplitter;
import ddf.minim.StereoBuffer;
import ddf.minim.spi.AudioOut;
import javax.sound.sampled.AudioFormat;

public class AudioSource
extends Controller
implements Effectable,
Recordable {
    private AudioOut stream;
    private SignalSplitter splitter;
    private StereoBuffer buffer;
    private EffectsChain effects;
    public final AudioBuffer left;
    public final AudioBuffer right;
    public final AudioBuffer mix;

    public AudioSource(AudioOut audioOut) {
        super(audioOut.getControls());
        this.stream = audioOut;
        this.buffer = new StereoBuffer(this.stream.getFormat().getChannels(), this.stream.bufferSize(), this);
        this.left = this.buffer.left;
        this.right = this.buffer.right;
        this.mix = this.buffer.mix;
        this.splitter = new SignalSplitter(this.stream.getFormat(), this.stream.bufferSize());
        this.splitter.addListener(this.buffer);
        this.stream.setAudioListener(this.splitter);
        this.effects = new EffectsChain();
        this.stream.setAudioEffect(this.effects);
        this.stream.open();
    }

    public void close() {
        this.stream.close();
    }

    @Override
    public void addEffect(AudioEffect audioEffect) {
        this.effects.add(audioEffect);
    }

    @Override
    public void clearEffects() {
        this.effects.clear();
    }

    @Override
    public void disableEffect(int n) {
        this.effects.disable(n);
    }

    @Override
    public void disableEffect(AudioEffect audioEffect) {
        this.effects.disable(audioEffect);
    }

    @Override
    public int effectCount() {
        return this.effects.size();
    }

    @Override
    public void effects() {
        this.effects.enableAll();
    }

    @Override
    public boolean hasEffect(AudioEffect audioEffect) {
        return this.effects.contains(audioEffect);
    }

    @Override
    public void enableEffect(int n) {
        this.effects.enable(n);
    }

    @Override
    public void enableEffect(AudioEffect audioEffect) {
        this.effects.enable(audioEffect);
    }

    @Override
    public AudioEffect getEffect(int n) {
        return this.effects.get(n);
    }

    @Override
    public boolean isEffected() {
        return this.effects.hasEnabled();
    }

    @Override
    public boolean isEnabled(AudioEffect audioEffect) {
        return this.effects.isEnabled(audioEffect);
    }

    @Override
    public void noEffects() {
        this.effects.disableAll();
    }

    @Override
    public void removeEffect(AudioEffect audioEffect) {
        this.effects.remove(audioEffect);
    }

    @Override
    public AudioEffect removeEffect(int n) {
        return this.effects.remove(n);
    }

    @Override
    public void addListener(AudioListener audioListener) {
        this.splitter.addListener(audioListener);
    }

    @Override
    public int bufferSize() {
        return this.stream.bufferSize();
    }

    @Override
    public AudioFormat getFormat() {
        return this.stream.getFormat();
    }

    @Override
    public void removeListener(AudioListener audioListener) {
        this.splitter.removeListener(audioListener);
    }

    @Override
    public int type() {
        return this.stream.getFormat().getChannels();
    }

    @Override
    public float sampleRate() {
        return this.stream.getFormat().getSampleRate();
    }
}

